<script type="text/javascript">
    $(function(){
        'use strict';

        var repair_job_params = {
            "device_filter": "[name='device_filter']", // Changed from client
            "appointment_type_filter": "[name='appointment_type_filter']",
            "from_date_filter": "[name='from_date_filter']",
            "to_date_filter": "[name='to_date_filter']",
        };
        var repair_job_table = $('table.table-repair_job_table');
        var _table_api = initDataTable(repair_job_table, admin_url+'workshop/repair_job_table', [0], [0], repair_job_params, ['0', 'desc']);
        var hidden_columns = [0];
        $('.table-repair_job_table').DataTable().columns(hidden_columns).visible(false, false);

        $.each(repair_job_params, function(i, obj) {
            $('select' + obj).on('change', function() {  
                $('.table-repair_job_table').DataTable().ajax.reload();
            });
        });

        $('#from_date_filter').on('change', function() {
            repair_job_table.DataTable().ajax.reload();
        });
        $('#to_date_filter').on('change', function() {
            repair_job_table.DataTable().ajax.reload();
        });

    });
    function repair_job_modal(repair_job_id) {
        "use strict";

        $("#modal_wrapper").load("<?php echo admin_url('workshop/load_repair_job_modal'); ?>", {
          repair_job_id: repair_job_id,
      }, function() {
          $("body").find('#repair_jobModal').modal({ show: true, backdrop: 'static' });
          init_selectpicker();
          init_datepicker();

      });

    }

    function delete_repair_job(id) {
        "use strict";

        if (confirm_delete()) {
            $.post(admin_url + "workshop/delete_repair_job/" + id).done(function (response) {
                response = JSON.parse(response);

                if (response.success === true || response.success == "true") {
                    alert_float('success', response.message)
                    $('.table-repair_job_table').DataTable().ajax.reload();
                }
            });
        }
    }

    function delete_repair_job_attachment(wrapper, attachment_id) {
        "use strict";  

        if (confirm_delete()) {
            $.get(admin_url + 'workshop/delete_repair_job_attachment/' +attachment_id, function (response) {
                if (response.success == true) {
                    $(wrapper).parents('.dz-preview').remove();

                    var totalAttachmentsIndicator = $('.dz-preview'+attachment_id);
                    var totalAttachments = totalAttachmentsIndicator.text().trim();

                    if(totalAttachments == 1) {
                        totalAttachmentsIndicator.remove();
                    } else {
                        totalAttachmentsIndicator.text(totalAttachments-1);
                    }
                    alert_float('success', "<?php echo _l('wshop_deleted_repair_job_image_successfully') ?>");

                } else {
                    alert_float('danger', "<?php echo _l('wshop_deleted_repair_job_image_failed') ?>");
                }
            }, 'json');
        }
        return false;
    }

    function repair_job_status_mark_as(status, id, type) {
        "use strict"; 
        
        var url = 'workshop/repair_job_status_mark_as/' + status + '/' + id + '/' + type;
        var taskModalVisible = $('#task-modal').is(':visible');
        url += '?single_task=' + taskModalVisible;
        $("body").append('<div class="dt-loader"></div>');

        requestGetJSON(url).done(function (response) {
            $("body").find('.dt-loader').remove();
            if (response.success === true || response.success == 'true') {

                var av_tasks_tables = ['table.table-repair_job_table'];
                $.each(av_tasks_tables, function (i, selector) {
                    if ($.fn.DataTable.isDataTable(selector)) {
                        $(selector).DataTable().ajax.reload(null, false);
                    }
                });
                alert_float('success', response.message);
                
                if(current_view == 'grid') {
                    window.location.reload();
                }
            }
        });
    }
</script>
<script>
    var current_view = 'grid';

    function switch_view(view) {
        current_view = view;
        var gridView = $('#repair-job-grid-view');
        var listView = $('#repair-job-list-view');

        if(view == 'grid'){
            listView.addClass('hide');
            gridView.removeClass('hide');
            
            $('#btn-grid-view').addClass('active');
            $('#btn-list-view').removeClass('active');
            
            filter_grid(); 
        } else {
            gridView.addClass('hide');
            
            listView.removeClass('hide');
            $('#btn-list-view').addClass('active');
            $('#btn-grid-view').removeClass('active');
        }
    }

    function filter_grid() {
        var device_id = $('select[name="device_filter"]').val();
        var appointment_type = $('select[name="appointment_type_filter"]').val();
        var from_date = $('input[name="from_date_filter"]').val();
        var to_date = $('input[name="to_date_filter"]').val();

        $('.repair-job-card-item').each(function() {
            var match = true;
            if(device_id && $(this).data('device-id') != device_id) match = false;
            if(appointment_type && $(this).data('appointment-type') != appointment_type) match = false;
            
            // Date Logic
            var card_date = $(this).data('date'); // Y-m-d
            if(card_date && (from_date || to_date)) {
                 var d_card = new Date(card_date);
                 d_card.setHours(0,0,0,0);

                 if(from_date) {
                     var d_from = new Date(from_date);
                     d_from.setHours(0,0,0,0);
                     if(d_card < d_from) match = false;
                 }
                 if(to_date) {
                     var d_to = new Date(to_date);
                     d_to.setHours(0,0,0,0);
                     if(d_card > d_to) match = false;
                 }
            }

            if(match) {
                $(this).removeClass('hide');
            } else {
                $(this).addClass('hide');
            }
        });
    }

    $(function(){
         // Hook into changes for grid filtering
         $('select[name="device_filter"], select[name="appointment_type_filter"], input[name="from_date_filter"], input[name="to_date_filter"]').on('change', function() {
             if(current_view == 'grid') {
                 filter_grid();
             }
         });
    });
</script>